            
            window.ub = {
                page: {
                    id: "2c6c717b-157e-44a9-9277-82ab07404a53",
                    variantId: "g",
                    usedAs: "main",
                    name: "LP BIO meta",
                    url: "http://assets/images/",
                    dimensions: { breakpoints: ["desktop", "mobile"], desktop: { height: 8257, width: 1440 }, mobile: { height: 8760, width: 320 }, mobileMaxWidth: 600 },
                },
                hooks: { beforeFormSubmit: [], afterFormSubmit: [] },
            };


            
            window.ub.page.webFonts = ["Red Hat Display:700,600,500,regular,800,300,900,700italic,italic", "Inter:700", "Caprasimo:regular,400", "Gelasio:600,600italic"];

            
            (function () {
                // Check for Responsive Content Script
                if (!window.ub || window.ub.autoscaleInitialized) {
                    return;
                }

                window.ub.autoscaleInitialized = true;

                var MOBILE_EDGE_BUFFER = 16;
                var MAX_MOBILE_SCALE = 1.25;

                var breakpoints = [
                    { name: "desktop", contentWidth: 1440 },
                    { name: "mobile", width: 600, contentWidth: 320 },
                ];

                function debounce(fn) {
                    var resizeTimer;

                    return function () {
                        if (resizeTimer) cancelAnimationFrame(resizeTimer);
                        resizeTimer = requestAnimationFrame(fn);
                    };
                }

                function resize() {
                    var size = 1;

                    // Width with scroll bar
                    var windowWidth = window.innerWidth;

                    // Width without scroll bar
                    var documentWidth = document.documentElement.clientWidth;

                    for (var i = 0; i < breakpoints.length; i++) {
                        var breakpoint = breakpoints[i];
                        if (windowWidth <= (breakpoint.width || Infinity)) {
                            var maxScale = breakpoint.name === "mobile" ? MAX_MOBILE_SCALE : 1;
                            var edgeBuffer = breakpoint.name === "mobile" ? MOBILE_EDGE_BUFFER : 0;

                            size = Math.min((documentWidth - edgeBuffer) / breakpoint.contentWidth, maxScale);
                        }
                    }

                    document.documentElement.style.setProperty("--scale", size);
                }

                var debouncedResize = debounce(resize);

                // Mutation observer ensures that autoscale works when elements are added or removed from the DOM
                var observer = new MutationObserver((mutationsList, observer) => {
                    for (var i = 0; i < mutationsList.length; i++) {
                        const mutation = mutationsList[i];
                        if (mutation.type === "childList" && (mutation.addedNodes.length > 0 || mutation.removedNodes.length > 0)) {
                            debouncedResize();
                            break;
                        }
                    }
                });

                // Initial resize
                resize();

                // Listen for resize events
                window.addEventListener("resize", debouncedResize);

                // Start observing the document body
                observer.observe(document.documentElement, { childList: true, subtree: true });
            })();
        

            
            (() => {
                const obs = new IntersectionObserver(
                    ents => {
                        ents.forEach(e => {
                            if (e.isIntersecting) {
                                e.target.classList.add("ub-ani-play");
                            } else {
                                e.target.classList.remove("ub-ani-play");
                            }
                        });
                    },
                    { threshold: 0.5 }
                );
                const els = document.querySelectorAll('[class*="ub-ani"]');
                els.forEach(el => obs.observe(el));
            })();















const swiper2suclick = new Swiper('.swiper_de_click', {
    loop: false, // Permet un défilement infini
    breakpoints: {
        768: { slidesPerView: 3, spaceBetween: 20 }, // Tablette (2 slides)
    },
    slidesPerView: 1.7, // Affiche un seul slide
    freeMode: true, // Active le mode libre
    spaceBetween: 10, // L'espace entre les slides
    overflow: 'initial', // Pour définir l'overflow de manière initiale
});

const swiper2suclick22 = new Swiper('.swiper_de_click_plats', {
    loop: false, // Permet un défilement infini
    breakpoints: {
        768: { slidesPerView: 2.4, spaceBetween: 20 }, // Tablette (2 slides)
    },
    pagination: {
        el: '.swiper-pagination',
        clickable: true,
    },
    slidesPerView: 1.3, // Affiche un seul slide
    spaceBetween: 15, // L'espace entre les slides
    overflow: 'initial', // Pour définir l'overflow de manière initiale
});
